package com.yiboshi.science.service;


import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProjectCheck;
import com.yiboshi.science.entity.ComProjectAudit;
import com.yiboshi.science.param.dto.ComProjectCheckDTO;
import com.yiboshi.science.param.dto.DataStatisticsDTO;
import com.yiboshi.science.param.query.ComProjectCheckQueryVO;

/**
 * 中期考核表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectCheckService extends BaseService<ComProjectCheckQueryVO, ComProjectCheckDTO, ComProjectCheck>{
    /**
     * 根据id更新状态
     *
     * @param id
     * @param state
     */
    void updateState(String id, Integer state);

    /**
     * 保存中期考核表信息并上报
     *
     * @param comProjectCheckDTO
     * @param unitId
     * @param treeCode
     * @return
     */
    String saveAndReport(ComProjectCheckDTO comProjectCheckDTO, String unitId, String treeCode);

    /**
     * 保存中期考核表信息
     *
     * @param comProjectCheckDTO
     * @return
     */
    String save(ComProjectCheckDTO comProjectCheckDTO);

    /**
     * 根据id获取中期考核表
     *
     * @param id
     * @return
     */
    ComProjectCheckDTO getCheckInfoById(String id);

    /**
     * 项目/任务书/中期考核审核
     *
     * @param comProjectAudit
     * @param unitId
     * @param treeCode
     * @return
     */
    void audit(ComProjectAudit comProjectAudit, String unitId, String treeCode);

    /**
     * 插入中期考核记录
     *
     * @param testId
     */
    void insertCheckListByTestId(String testId);
    /**
     * 获取统计数据
     *
     * @return
     */
    DataStatisticsDTO getCount(ComProjectCheckQueryVO e);
}
