package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.entity.SystemMenuRole;
import com.yiboshi.science.param.dto.MenuTreeDTO;
import com.yiboshi.science.param.dto.SystemMenuRoleDTO;
import com.yiboshi.science.param.query.SystemMenuRoleQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.SystemMenuRoleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 功能：菜单权限表 接口
 * @author lkl
 * @version 2021-08-26
 */
@Api(tags = "system-menu-role",description = "菜单权限表")
@RestController
@RequestMapping("/v1/science-admin/system-menu-role")
public class SystemMenuRoleController extends BaseController<SystemMenuRoleService, SystemMenuRoleQueryVO, SystemMenuRoleDTO, SystemMenuRole> {

    @Autowired
    private SystemMenuRoleService systemMenuRoleService;

    @ApiOperation(value = "根据角色Id获取菜单", httpMethod = "GET", notes = "根据角色Id获取菜单")
    @GetMapping
    @RequestMapping("/getMenuRoleByRoleId")
    public ResponseDataModel<List<SystemMenuRole>> getMenuRoleByRoleId(int roleId) {
        return ResponseDataModel.ok(systemMenuRoleService.getMenuRoleByRoleId(roleId));
    }

    @ApiOperation(value = "更新角色菜单权限", httpMethod = "POST", notes = "更新角色菜单权限")
    @RequestMapping("/updateMenuRole")
    @PostMapping
    public ResponseDataModel<String> updateMenuRole(List<SystemMenuRole> menuRoleList) {
        return ResponseDataModel.ok(systemMenuRoleService.updateMenuRole(menuRoleList));
    }

    @ApiOperation(value = "插入角色菜单记录", httpMethod = "POST", notes = "插入角色菜单记录")
    @RequestMapping("/insertMenuRoleRecord")
    @PostMapping
    public ResponseDataModel<String> insertMenuRoleRecord(@Validated @RequestBody MenuTreeDTO dto) {
        return ResponseDataModel.ok(systemMenuRoleService.insertMenuRoleRecord(dto));
    }

    @ApiOperation(value = "删除角色菜单记录", httpMethod = "DELETE", notes = "删除角色菜单记录")
    @RequestMapping("/deleteMenuRoleRecord")
    @PostMapping
    public ResponseDataModel<String> deleteMenuRoleRecord(@Validated @RequestBody MenuTreeDTO dto) {
        return ResponseDataModel.ok(systemMenuRoleService.deleteMenuRoleRecord(dto));
    }
}
