package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.SystemMenu;
import com.yiboshi.science.param.dto.MenuTreeDTO;
import com.yiboshi.science.param.dto.SystemMenuDTO;
import com.yiboshi.science.param.query.SystemMenuQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.SystemMenuService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 功能：菜单表 接口
 *
 * @author lkl
 * @version 2021-08-26
 */
@Api(tags = "system-menu", description = "菜单表")
@RestController
@RequestMapping("/v1/science-admin/system-menu")
public class SystemMenuController extends BaseController<SystemMenuService, SystemMenuQueryVO, SystemMenuDTO, SystemMenu> {

    @Autowired
    private SystemMenuService systemMenuService;

    @ApiOperation(value = "1.02 分页查询", httpMethod = "GET", notes = "1.02 根据参数获取列表")
    @GetMapping
    @RequestMapping("/getListByPage")
    public ResponseDataModel<Pagination<SystemMenuDTO>> getListByPage(@Validated SystemMenuQueryVO vo, BindingResult bindingResult) {
        return ResponseDataModel.ok(systemMenuService.getListByPage(vo));
    }


    @ApiOperation(value = "获取菜单树", httpMethod = "GET", notes = "获取菜单树")
    @GetMapping
    @RequestMapping("/getAllMenuTree")
    public ResponseDataModel<List<MenuTreeDTO>> getAllMenuTree() {
        return ResponseDataModel.ok(systemMenuService.getAllMenuTree());
    }

    @ApiOperation(value = "根据id获取菜单信息", httpMethod = "GET", notes = "根据id获取菜单信息")
    @GetMapping
    @RequestMapping("/getSystemMenuById")
    public ResponseDataModel<SystemMenu> getSystemMenuById(String id) {
        return ResponseDataModel.ok(systemMenuService.getSystemMenuById(id));
    }

    @ApiOperation(value = "添加菜单信息", httpMethod = "POST", notes = "添加菜单信息")
    @RequestMapping("/insertSystemMenu")
    @PostMapping
    public ResponseDataModel<String> insertSystemMenu(@RequestBody SystemMenu systemMenu) {
        return ResponseDataModel.ok(systemMenuService.insertSystemMenu(systemMenu));
    }

    @ApiOperation(value = "更新菜单信息", httpMethod = "POST", notes = "更新菜单信息")
    @RequestMapping("/updateSystemMenu")
    @PostMapping
    public ResponseDataModel<String> updateSystemMenu(@RequestBody SystemMenu systemMenu) {
        return ResponseDataModel.ok(systemMenuService.updateSystemMenu(systemMenu));
    }
}
