package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.LogsException;
import com.yiboshi.science.param.dto.LogsExceptionDTO;
import com.yiboshi.science.param.query.LogsExceptionQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.LogsExceptionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 功能：异常日志 接口
 * @author lkl
 * @version 2021-08-26
 */
@Api(tags = "logs-exception",description = "异常日志")
@RestController
@RequestMapping("/v1/science-admin/logs-exception")
public class LogsExceptionController extends BaseController<LogsExceptionService,LogsExceptionQueryVO, LogsExceptionDTO, LogsException> {

    @Autowired
    private LogsExceptionService logsExceptionService;

    @ApiOperation(value = "1.02 分页查询", httpMethod = "GET", notes = "1.02 根据参数获取列表")
    @GetMapping
    @RequestMapping("/getListByPage")
    public ResponseDataModel<Pagination<LogsExceptionDTO>> getListByPage(@Validated LogsExceptionQueryVO vo, BindingResult bindingResult) {
        Pagination<LogsExceptionDTO> page = logsExceptionService.getListByPage(vo);
        return ResponseDataModel.ok(page);
    }
}
