package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.ComTalentGroupDetail;
import com.yiboshi.science.param.dto.ComProjectGroupDetailDTO;
import com.yiboshi.science.param.dto.ComTalentGroupDetailDTO;
import com.yiboshi.science.param.query.ComProjectGroupDetailQueryVO;
import com.yiboshi.science.param.query.ComTalentGroupDetailQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.ComTalentGroupDetailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;

@Api(tags = "com-talent-group-detail", description = "人才分组明细表")
@RestController
@RequestMapping("/v1/science-admin/com-talent-group-detail")
public class ComTalentGroupDetailController extends BaseController<ComTalentGroupDetailService, ComTalentGroupDetailQueryVO, ComTalentGroupDetailDTO, ComTalentGroupDetail> {

    @Autowired
    private ComTalentGroupDetailService comTalentGroupDetailService;

    @ApiOperation(value = "1.02 分页查询", httpMethod = "GET", notes = "1.02 根据参数获取列表")
    @GetMapping
    @RequestMapping("/getTalentDetailListbyPage")
    public ResponseDataModel<Pagination<ComTalentGroupDetailDTO>> getTalentDetailListbyPage(@Validated ComTalentGroupDetailQueryVO vo, BindingResult bindingResult) {
        Pagination<ComTalentGroupDetailDTO> page = comTalentGroupDetailService.getTalentDetailListbyPage(vo);
        return ResponseDataModel.ok(page);
    }

    @ApiOperation(value = "根据类型参数列表", httpMethod = "GET", notes = "根据类型参数列表")
    @GetMapping
    @RequestMapping("/getTalentListByGroupIds")
    public ResponseDataModel<List<ComTalentGroupDetailDTO>> getTalentListByGroupIds(@RequestParam String groupIds) {
        String[] split = groupIds.split(",");
        List<String> GroupList = Arrays.asList(split);
        List<ComTalentGroupDetailDTO> list = comTalentGroupDetailService.getTalentListByGroupIds(GroupList);
        list.forEach(e -> {
            e.setKey(e.getId());
//            e.setTitle(e.getProjNo());
//            e.setDescription(e.getProjName());
        });
        return ResponseDataModel.ok(list);
    }
}
