package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 查询操作日志表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "查询操作日志表VO")
public class LogsOperationQueryVO extends PaginationVO{
    /** 操作人Id */
    @ApiModelProperty(value = "操作人Id", position = 1)
    private String customerId;
    /** 关键字 */
    @ApiModelProperty(value = "关键字", position = 2)
    private String logKey;
    /** 日志参数 */
    @ApiModelProperty(value = "日志参数", position = 3)
    private String logParam;
    /** 请求地址 */
    @ApiModelProperty(value = "请求地址", position = 6)
    private String requestUrl;
    /** 用户浏览器信息 */
    @ApiModelProperty(value = "用户浏览器信息", position = 5)
    private String browser;
    /** 用户IP */
    @ApiModelProperty(value = "用户IP", position = 6)
    private String ipAddress;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 4 )
    @Length(max=100, message = "备注不能大于100")
    private String remark;


    /** 起始时间 */
    @ApiModelProperty(value = "起始时间", position = 10)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    /** 截止时间 */
    @ApiModelProperty(value = "截止时间", position = 11)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;
}