package com.yiboshi.science.param.query;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "人才专家分配明细表VO")
public class ComTalentAssignQueryVO extends PaginationVO {

    /** 专家Id */
    @ApiModelProperty(value = "专家Id", position = 1)
    @Length(max=36, message = "专家Id不能大于36")
    private String expertId;

    /** 人才Id */
    @ApiModelProperty(value = "人才Id", position = 2)
    @Length(max=36, message = "人才Id不能大于36")
    private String talentId;

    /** 分配年度 */
    @ApiModelProperty(value = "分配年度", position = 3)
    private Integer assignYear;

    /** 审核状态（0 未评审 1 保存 2 已提交） */
    @ApiModelProperty(value = "审核状态（0 未评审 1 保存 2 已提交）", position = 11)
    private Integer auditState;

    /** 总分 */
    @ApiModelProperty(value = "总分", position = 9)
    private BigDecimal totalScore;

    /** 备注 */
    @ApiModelProperty(value = "备注", position =10)
    @Length(max=65535, message = "备注不能大于65535")
    private String remark;

    /** 证件号 */
    @ExcelProperty("证件号")
    @ApiModelProperty(value = "证件号", position = 1)
    private String certId;
    /** 姓名 */
    @ExcelProperty("姓名")
    @ApiModelProperty(value = "姓名", position = 3)
    private String personName;
    /** 性别 */
    @ExcelProperty("性别")
    @ApiModelProperty(value = "性别", position = 4)
    private String sex;
    /** 出生日期 */
    @ApiModelProperty(value = "出生日期", position = 5)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date birthday;
    /** 职称 */
    @ApiModelProperty(value = "职称", position = 7)
    private String title;
    /** 学位 */
    @ApiModelProperty(value = "学位", position = 8 )
    private String degree;
    /** 邮箱 */
    @ApiModelProperty(value = "邮箱", position = 9)
    private String email;
    /** 电话号码 */
    @ApiModelProperty(value = "电话号码", position = 10)
    private String mobile;
    /** 单位 */
    @ApiModelProperty(value = "单位", position = 13)
    private String unitName;
    /** 工作单位 */
    @ApiModelProperty(value = "工作单位", position = 13)
    private String workUnit;

    /** 姓名 */
    @ExcelProperty("姓名")
    @ApiModelProperty(value = "姓名", position = 3)
    private String appUnitName;
    /** 项目负责人 */
    @ApiModelProperty(value = "项目负责人", position = 6)
    private String appPersonName;
    /** 项目组Id */
    @ApiModelProperty(value = "项目组Id", position = 6)
    private String groupId;

    /** 专家姓名 */
    @ExcelProperty("专家姓名")
    @ApiModelProperty(value = "姓名", position = 3)
    private String expertName;

    /** 专家电话 */
    @ApiModelProperty(value = "专家电话", position = 10)
    private String expertMobile;
}
