package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 查询项目表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "查询项目表VO")
public class ComProjectQueryVO extends PaginationVO{
    /** 项目名称 */
    @ApiModelProperty(value = "项目名称", position = 1 )
    @Length(max=150, message = "项目名称不能大于50")
    private String projName;
    /** 项目名称(英文) */
    @ApiModelProperty(value = "项目名称(英文)", position = 1 )
    @Length(max=500, message = "项目名称(英文)不能大于500")
    private String englishName;
    /** 项目编号 */
    @ApiModelProperty(value = "项目编号", position = 2 )
    @Length(max=100, message = "项目编号不能大于100")
    private String projNo;
    /** 申请编号 */
    @ApiModelProperty(value = "申请编号", position = 4 )
    @Length(max=200, message = "申请编号不能大于200")
    private String appNo;
    /** 版本号 */
    @ApiModelProperty(value = "版本号", position = 5 )
    @Length(max=20, message = "版本号不能大于20")
    private String versionNo;
    /** 申报单位Id */
    @ApiModelProperty(value = "申报单位Id", position = 8 )
    @Length(max=36, message = "申报单位Id不能大于36")
    private String appUnitId;
    /** 申报人Id */
    @ApiModelProperty(value = "申报人Id", position = 9 )
    @Length(max=36, message = "申报人Id不能大于36")
    private String appPersonId;
    /** 申报年度 */
    @ApiModelProperty(value = "申报年度", position = 6 )
    private Integer reportYear;
    /** 申报批次 */
    @ApiModelProperty(value = "申报批次", position = 7 )
    private Integer batch;
    /** 主管处室 */
    @ApiModelProperty(value = "主管处室", position = 1)
    private String managerDept;
    /** 项目状态 -10 起草,10 待提交, 20 已提交至依托单位,25 依托单位审核通过，请打印申请书,30 返回修改,40 未批准立项,50 批准立项 */
    @ApiModelProperty(value = "项目状态 -10 起草,10 待提交, 20 已提交至依托单位,25 依托单位审核通过，请打印申请书,30 返回修改,40 未批准立项,50 批准立项", position = 7 )
    private Integer projState;
    /** 项目类型  1 科研项目  2重点学科项目 */
    @ApiModelProperty(value = "项目名称", position = 1 )
    private Integer systemType;
    /** 项目类别 (1 一般项目 2重点项目)*/
    @ApiModelProperty(value = "项目类别 (1 一般项目 2重点项目)", position = 3 )
    private Integer projClass;
    /** 项目开始时间 */
    @ApiModelProperty(value = "项目开始时间", position = 10 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    /** 项目结束时间 */
    @ApiModelProperty(value = "项目结束时间", position = 11 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;
    /** 学科Id */
    @ApiModelProperty(value = "学科Id", position = 16 )
    @Length(max=36, message = "学科Id不能大于36")
    private String knowledgeId;
    /** 专家/专家组是否评审完成  0否 1是 */
    @ApiModelProperty(value = "是否评审完成", position = 6 )
    private Integer completed;
    /** 分配状态 0未分配 1已分配 */
    @ApiModelProperty(value = "分配状态", position = 6 )
    private Integer assignState;
    /** 总分 */
    @ApiModelProperty(value = "总分", position = 4)
    private BigDecimal totalScore;
    /** 平均分 */
    @ApiModelProperty(value = "平均分", position = 4)
    private BigDecimal averageScore;
    /** 技术专家总分 */
    @ApiModelProperty(value = "技术专家总分", position = 4)
    private BigDecimal technologyScore;
    /** 技术专家平均分 */
    @ApiModelProperty(value = "技术专家平均分", position = 4)
    private BigDecimal technologyAverageScore;
    /** 财务专家总分 */
    @ApiModelProperty(value = "财务专家总分", position = 4)
    private BigDecimal economyScore;
    /** 财务专家平均分 */
    @ApiModelProperty(value = "财务专家平均分", position = 4)
    private BigDecimal economyAverageScore;
    /** 计算得分 */
    @ApiModelProperty(value = "计算得分", position = 4)
    private BigDecimal calculateScore;

    /** 项目完成状态 */
    @ApiModelProperty(value = "项目完成状态", position = 38 )
    private String completeStatus;

    /** 是否终审返回修改  0否 1是 */
    @ApiModelProperty(value = "是否终审返回修改", position = 6 )
    private Integer isFinalReturned;

    /** 项目Id */
    @ApiModelProperty(value="项目Id")
    @Length(max=36, message = "Id不能大于36")
    private String projId;
    /** 单位名称 */
    @ApiModelProperty(value = "单位名称", position = 1)
    @Length(max=200, message = "单位名称不能大于200")
    private String appUnitName;
    /** 注册单位类型 */
    @ApiModelProperty(value = "注册单位类型", position = 1)
    @Length(max=36, message = "注册单位类型不能大于36")
    private String unitType;
    /** 组织机构代码/统一社会信用代码 */
    @ApiModelProperty(value = "组织机构代码/统一社会信用代码", position = 1 )
    @Length(max=50, message = "组织机构代码/统一社会信用代码不能大于50")
    private String organizationCode;
    /** 通讯地址 */
    @ApiModelProperty(value = "通讯地址", position = 1)
    @Length(max=200, message = "通讯地址不能大于200")
    private String address;
    /** 注册所在地 */
    @ApiModelProperty(value = "注册所在地", position = 1 )
    @Length(max=50, message = "注册所在地不能大于50")
    private String registeredAddress;
    /** 邮编 */
    @ApiModelProperty(value = "邮编", position = 1 )
    @Length(max=10, message = "邮编不能大于10")
    private String postCode;
    /** 法定代表人 */
    @ApiModelProperty(value = "法定代表人", position = 1 )
    @Length(max=50, message = "法定代表人不能大于50")
    private String legalPerson;

    /** 职工总数 */
    @ApiModelProperty(value = "职工总数", position = 1 )
    private Integer workforce;
    /** 其中专科以上人员 */
    @ApiModelProperty(value = "其中专科以上人员", position = 1 )
    private Integer specializedPersonnel;
    /** 研究开发人员 */
    @ApiModelProperty(value = "研究开发人员", position = 1 )
    private Integer researchPersonnel;

    /** 开户银行 */
    @ApiModelProperty(value = "开户银行", position = 1 )
    @Length(max=100, message = "开户银行不能大于100")
    private String depositBank;
    /** 银行账号 */
    @ApiModelProperty(value = "银行账号", position = 1 )
    @Length(max=50, message = "银行账号不能大于50")
    private String bankAccount;
    /** 开户银行地址 */
    @ApiModelProperty(value = "开户银行地址", position = 1 )
    @Length(max=100, message = "开户银行地址不能大于100")
    private String depositBankAddress;
    /** 银行联行号 */
    @ApiModelProperty(value = "银行联行号", position = 1 )
    @Length(max=50, message = "银行联行号不能大于50")
    private String interbankNumber;

    /** 上年度研发经费支出总额(单位:万元) */
    @ApiModelProperty(value = "上年度研发经费支出总额(单位:万元)", position = 1 )
    private BigDecimal researchTotal;
    /** 上年度是否填报了研发活动情况 0 否 1 是 */
    @ApiModelProperty(value = "上年度是否填报了研发活动情况", position = 1 )
    private Integer isResearchActive;
    /** 上一年度填报的研发投入总数(单位:万元) */
    @ApiModelProperty(value = "上一年度填报的研发投入总数(单位:万元)", position = 1 )
    private BigDecimal researchCount;
    /** 上一年度填报的研发人员数 */
    @ApiModelProperty(value = "上一年度填报的研发人员数", position = 1 )
    private Integer researchPersonCount;

    /** 项目所属二级学院/部门名称(牵头单位) */
    @ApiModelProperty(value = "项目所属二级学院/部门名称(牵头单位)", position = 1 )
    @Length(max=100, message = "项目所属二级学院/部门名称(牵头单位)不能大于100")
    private String leadUnit;
    /** 推荐部门 */
    @ApiModelProperty(value = "推荐部门", position = 1 )
    @Length(max=100, message = "推荐部门不能大于100")
    private String recommendUnit;
    /** 项目依托的科技创新基地 */
    @ApiModelProperty(value = "项目依托的科技创新基地", position = 1 )
    @Length(max=100, message = "项目依托的科技创新基地不能大于100")
    private String technologyInnovationBase;


    /** 项目总经费(万元） */
    @ApiModelProperty(value = "项目总经费(万元）", position = 39)
    private BigDecimal totalFunding;
    /** 申请科技经费(万元) */
    @ApiModelProperty(value = "申请科技经费(万元)", position = 40)
    private BigDecimal govFunding;
    /** 单位配套 */
    @ApiModelProperty(value = "单位配套", position = 41)
    private BigDecimal unitFunding;
    /** 自筹 */
    @ApiModelProperty(value = "自筹", position = 42)
    private BigDecimal selfFunding;
    /** 其他 */
    @ApiModelProperty(value = "其他", position = 43)
    private BigDecimal otherFunding;

    /** 项目联系人姓名 */
    @ApiModelProperty(value = "项目联系人姓名", position = 16)
    @Length(max=100, message = "项目联系人姓名不能大于100")
    private String linkName;
    /** 联系人手机 */
    @ApiModelProperty(value = "联系人手机", position = 16)
    @Length(max=50, message = "联系人手机不能大于50")
    private String linkMobile;
    /** 电子邮箱 */
    @ApiModelProperty(value = "电子邮箱", position = 16)
    @Length(max=100, message = "电子邮箱不能大于100")
    private String linkEmail;

    /** 项目摘要 */
    @ApiModelProperty(value = "项目摘要", position = 13 )
    @Length(max=600, message = "项目摘要不能大于600")
    private String projAbstract;
    /** 关键词 */
    @ApiModelProperty(value = "关键词", position = 26 )
    @Length(max=200, message = "关键词不能大于200")
    private String projKeywords;

    /** 项目的意义、必要性 */
    @ApiModelProperty(value = "主要研究内容和意义", position = 13 )
    @Length(max=2147483647, message = "主要研究内容和意义不能大于2147483647")
    private String projContent;
    /** 项目现有工作基础和支撑条件 */
    @ApiModelProperty(value = "项目现有工作基础和支撑条件", position = 35 )
    @Length(max=2147483647, message = "项目现有工作基础和支撑条件不能大于2147483647")
    private String memResume;
    /** 与项目相关的国内外技术发展现状(包括知识产权情况)以及本项目主要研究开发内容技术关键(创新点)、可行性评价及项目风险分析与对策 */
    @ApiModelProperty(value = "与项目相关的国内外技术发展现状(包括知识产权情况)以及本项目主要研究开发内容技术关键(创新点)、可行性评价及项目风险分析与对策", position = 30 )
    @Length(max=2147483647, message = "不能大于2147483647")
    private String researchProgress;

    /** 项目实施目标 */
    @ApiModelProperty(value = "项目实施目标", position = 28 )
    @Length(max=2147483647, message = "项目实施目标不能大于2147483647")
    private String researchContent;
    /** 主要技术指标 */
    @ApiModelProperty(value = "主要技术指标", position = 35 )
    @Length(max=2147483647, message = "主要技术指标不能大于2147483647")
    private String technologyTarget;
    /** 主要经济指标 */
    @ApiModelProperty(value = "主要经济指标", position = 35 )
    @Length(max=2147483647, message = "主要经济指标不能大于2147483647")
    private String economyTarget;
    /** 项目实施中形成的示范基地、中试线、生产线及其规模等 */
    @ApiModelProperty(value = "项目实施中形成的示范基地、中试线、生产线及其规模等", position = 35 )
    @Length(max=2147483647, message = "项目实施中形成的示范基地、中试线、生产线及其规模等不能大于2147483647")
    private String achievementTarget;
    /** 其他应考核的指标 */
    @ApiModelProperty(value = "其他应考核的指标", position = 35 )
    @Length(max=2147483647, message = "其他应考核的指标不能大于2147483647")
    private String otherTarget;

    /** 立项依据 */
    @ApiModelProperty(value = "立项依据", position = 27 )
    @Length(max=2147483647, message = "立项依据不能大于2147483647")
    private String projBasis;
    /** 研究思路、方法、技术路线、实验方案及可行性分析 */
    @ApiModelProperty(value = "研究思路、方法、技术路线、实验方案及可行性分析", position = 29 )
    @Length(max=2147483647, message = "研究思路、方法、技术路线、实验方案及可行性分析不能大于2147483647")
    private String researchPlan;
    /** 创新点/项目的特色和创新之处 */
    @ApiModelProperty(value = "创新点/项目的特色和创新之处", position = 31 )
    @Length(max=2147483647, message = "创新点/项目的特色和创新之处不能大于2147483647")
    private String mainFeatures;
    /** 预期研究成果 */
    @ApiModelProperty(value = "预期研究成果", position = 32 )
    @Length(max=2147483647, message = "预期研究成果不能大于2147483647")
    private String expectedResults;
    /** 申请者正在承担的其它研究项目 */
    @ApiModelProperty(value = "申请者正在承担的其它研究项目", position = 14 )
    @Length(max=1000, message = "申请者正在承担的其它研究项目1000")
    private String researchProjects;
    @ApiModelProperty(value = "报告正文", position = 36 )
    @Length(max=2147483647, message = "报告正文不能大于2147483647")
    private String projDoc;

    /** 备注 */
    @ApiModelProperty(value = "备注", position = 38 )
    @Length(max=65535, message = "备注不能大于65535")
    private String remark;

    /** 姓名 */
    @ApiModelProperty(value = "姓名", position = 41)
    private String appPersonName;
    /** 注册单位类型 */
    @ApiModelProperty(value = "注册单位类型", position = 12)
    @Length(max=100, message = "注册单位类型不能大于100")
    private String unitTypeName;
}
