package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 查询项目组成员表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "查询项目组成员表VO") 
public class ComProjectMembersQueryVO extends PaginationVO{
    /** 对象Id(项目Id/任务书Id) */
    @ApiModelProperty(value = "对象Id(项目Id/任务书Id)", position = 1 )
    @Length(max=36, message = "对象Id(项目Id/任务书Id)不能大于36")
    private String objectId;
    /** 姓名 */
    @ApiModelProperty(value = "姓名", position = 2 )
    @Length(max=60, message = "姓名不能大于60")
    private String name;
    /** 证件号 */
    @ApiModelProperty(value = "证件号", position = 1)
    @Length(max=100, message = "证件号不能大于100")
    private String certId;
    /** 性别 */
    @ApiModelProperty(value = "性别", position = 4 )
    @Length(max=2, message = "性别不能大于2")
    private String sex;
    /** 出生年月 */
    @ApiModelProperty(value = "出生年月", position = 3 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date birthday;
    /** 年龄 */
    @ApiModelProperty(value = "年龄", position = 5 )
    private Integer age;
    /** 职务 */
    @ApiModelProperty(value = "职务", position = 9 )
    @Length(max=36, message = "职务不能大于36")
    private String duty;
    /** 学历 */
    @ApiModelProperty(value = "学历", position = 8)
    @Length(max=36, message = "学历不能大于36")
    private String education;
    /** 专业 */
    @ApiModelProperty(value = "专业", position = 11)
    @Length(max=36, message = "专业不能大于36")
    private String spec;
    /** 职称 */
    @ApiModelProperty(value = "职称", position = 5 )
    @Length(max=36, message = "职称不能大于36")
    private String title;
    /** 学位 */
    @ApiModelProperty(value = "学位", position = 4 )
    @Length(max=36, message = "学位不能大于36")
    private String degree;
    /** 工作单位 */
    @ApiModelProperty(value = "工作单位", position = 7 )
    @Length(max=200, message = "工作单位不能大于200")
    private String workUnit;
    /** 研究方向 */
    @ApiModelProperty(value = "研究方向", position = 6 )
    @Length(max=200, message = "研究方向不能大于200")
    private String researchDirection;
    /** 项目分工 */
    @ApiModelProperty(value = "项目分工", position = 8 )
    @Length(max=300, message = "项目分工不能大于300")
    private String projWork;
    /** 年参加月数 */
    @ApiModelProperty(value = "年参加月数", position = 9 )
    private Integer forMonths;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 10 )
    private Integer showIndex;
    /** 角色 1项目负责人 2一般成员 */
    @ApiModelProperty(value = "角色 1项目负责人 2一般成员", position = 11 )
    private Integer role;
    /** 附件Id */
    @ApiModelProperty(value = "附件Id", position = 4 )
    private String fileId;
}