package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 查询项目表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "查询项目表VO")
public class ComProjectBasicQueryVO extends PaginationVO{
    /** 项目Id */
    @ApiModelProperty(value="项目Id")
    @Length(max=36, message = "Id不能大于36")
    private String projId;

    /** 每年工作时间(月) */
    @ApiModelProperty(value = "每年工作时间(月)", position = 1 )
    private Integer jobTime;
    /** 主要研究领域 */
    @ApiModelProperty(value = "主要研究领域", position = 19 )
    @Length(max=200, message = "主要研究领域不能大于200")
    private String mainResearchAreas;
    /** 申报人通信地址 */
    @ApiModelProperty(value = "申报人通信地址", position = 15 )
    @Length(max=200, message = "申报人通信地址不能大于200")
    private String address;

    /** 单位联系人姓名 */
    @ApiModelProperty(value = "单位联系人姓名", position = 16)
    @Length(max=100, message = "单位联系人姓名不能大于100")
    private String unitLinkName;
    /** 单位联系人手机 */
    @ApiModelProperty(value = "单位联系人手机", position = 16)
    @Length(max=50, message = "单位联系人手机不能大于50")
    private String unitLinkMobile;
    /** 单位电子邮箱 */
    @ApiModelProperty(value = "单位电子邮箱", position = 16)
    @Length(max=100, message = "单位电子邮箱不能大于100")
    private String unitLinkEmail;
    /** 单位传真 */
    @ApiModelProperty(value = "单位传真", position = 16)
    @Length(max=100, message = "单位传真不能大于100")
    private String unitLinkFax;

    /** 选题范围 */
    @ApiModelProperty(value = "选题范围", position = 1 )
    @Length(max=200, message = "主要研究领域不能大于200")
    private String subjectScope;
    /** 项目摘要 */
    @ApiModelProperty(value = "项目摘要", position = 13 )
    @Length(max=600, message = "项目摘要不能大于600")
    private String projAbstract;
    /** 关键词 */
    @ApiModelProperty(value = "关键词", position = 26 )
    @Length(max=200, message = "关键词不能大于200")
    private String projKeywords;

    /** 项目总经费(万元） */
    @ApiModelProperty(value = "项目总经费(万元）", position = 39)
    private BigDecimal totalFunding;
    /** 申请科技经费(万元) */
    @ApiModelProperty(value = "申请科技经费(万元)", position = 40)
    private BigDecimal govFunding;
    /** 单位配套 */
    @ApiModelProperty(value = "单位配套", position = 41)
    private BigDecimal unitFunding;
    /** 自筹 */
    @ApiModelProperty(value = "自筹", position = 42)
    private BigDecimal selfFunding;
    /** 其他 */
    @ApiModelProperty(value = "其他", position = 43)
    private BigDecimal otherFunding;

    /** 项目实施目标 */
    @ApiModelProperty(value = "项目实施目标", position = 28 )
    @Length(max=2147483647, message = "项目实施目标不能大于2147483647")
    private String researchContent;
    /** 主要技术指标 */
    @ApiModelProperty(value = "主要技术指标", position = 35 )
    @Length(max=2147483647, message = "主要技术指标不能大于2147483647")
    private String technologyTarget;
    /** 主要经济指标 */
    @ApiModelProperty(value = "主要经济指标", position = 35 )
    @Length(max=2147483647, message = "主要经济指标不能大于2147483647")
    private String economyTarget;
    /** 项目实施中形成的示范基地、中试线、生产线及其规模等 */
    @ApiModelProperty(value = "项目实施中形成的示范基地、中试线、生产线及其规模等", position = 35 )
    @Length(max=2147483647, message = "项目实施中形成的示范基地、中试线、生产线及其规模等不能大于2147483647")
    private String achievementTarget;
    /** 科技报告考核指标 */
    @ApiModelProperty(value = "科技报告考核指标", position = 35 )
    @Length(max=2147483647, message = "科技报告考核指标不能大于2147483647")
    private String technologyReportsTarget;
    /** 其他应考核的指标 */
    @ApiModelProperty(value = "其他应考核的指标", position = 35 )
    @Length(max=2147483647, message = "其他应考核的指标不能大于2147483647")
    private String otherTarget;

    @ApiModelProperty(value = "项目属性Id", position = 36)
    @Length(max=36, message = "项目属性Id不能大于36")
    private String projAttribute;
    /** 年度总目标 */
    @ApiModelProperty(value = "年度总目标", position = 14 )
    @Length(max=1000, message = "年度总目标1000")
    private String yearTarget;
    /** 第一年目标 */
    @ApiModelProperty(value = "第一年目标", position = 14 )
    @Length(max=500, message = "第一年目标500")
    private String year1Goal;
    /** 第二年目标 */
    @ApiModelProperty(value = "第二年目标", position = 14 )
    @Length(max=500, message = "第二年目标500")
    private String year2Goal;
    /** 第三年目标 */
    @ApiModelProperty(value = "第三年目标", position = 14 )
    @Length(max=500, message = "第三年目标500")
    private String year3Goal;
    /** 附件Id */
    @ApiModelProperty(value = "附件Id", position = 4 )
    private String fileId;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 38 )
    @Length(max=65535, message = "备注不能大于65535")
    private String remark;
}