package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 菜单表DTO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "菜单表DTO")
public class SystemMenuDTO extends BaseDTO {
    /** 菜单Id */
    @ApiModelProperty(value = "菜单Id", position = 1)
    private Integer menuId;
    /** 菜单名称 */
    @ApiModelProperty(value = "菜单名称", position = 2)
    private String menuName;
    /** 访问Url */
    @ApiModelProperty(value = "访问Url", position = 3)
    private String actionUrl;
    /** 图标 */
    @ApiModelProperty(value = "图标", position = 2 )
    private String icon;
    /** 窗口参数 */
    @ApiModelProperty(value = "窗口参数", position = 4)
    private String windowPara;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 5)
    private Integer showIndex;
    /** 父Id */
    @ApiModelProperty(value = "父Id", position = 6)
    private String parentId;
    /** 是否缓存  1是 ,0否*/
    @ApiModelProperty(value = "是否缓存", position = 5 )
    private Integer keepAlive;
}