package com.yiboshi.science.param.dto;


import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * @Auther: kylin
 * @Date: 2022/5/23 14:16
 * @Description:
 */
@Data
public class SMSParameterDTO implements Serializable {
    /** 手机号 */
    @ApiModelProperty(value = "手机号", position = 1)
    private String mobile;
    /** 应用id */
    @ApiModelProperty(value = "应用id", position = 1)
    private Integer appId;
    /** 模板id */
    @ApiModelProperty(value = "模板id", position = 1)
    private Integer tTypeId;
    /** 1代表当前是验证码类型的短信。2代表非验证码类型的短信。 */
    @ApiModelProperty(value = "类型", position = 1)
    private Integer smsType;
    /** 验证码 */
    @ApiModelProperty(value = "验证码", position = 1)
    private String code;
    /** 当前时间戳（毫秒） */
    @ApiModelProperty(value = "当前时间戳（毫秒）", position = 1)
    private Long timestamp;
    /** sha256 小写   手机号+时间戳   用于验签 */
    @ApiModelProperty(value = "验签", position = 1)
    private String sign;
    /**  短信验证码不需要传此参数。非验证码类型的短信需要传此参数 */
    @ApiModelProperty(value = "参数", position = 1)
    private SMSTemplateDTO paramMap;
}
