package com.yiboshi.science.param.dto;

import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "人才分组明细表DTO")
public class ComTalentGroupDetailDTO extends BaseDTO {

    /** 人才分组Id */
    @ApiModelProperty(value = "人才分组Id", position = 1)
    @Length(max=36, message = "人才分组Id不能大于36")
    private String groupId;

    /** 二级学科Id */
    @ApiModelProperty(value = "二级学科Id", position = 1)
    @Length(max=36, message = "二级学科Id不能大于36")
    private String knowledgeId;

    /** 人才Id */
    @ApiModelProperty(value = "人才Id", position = 2)
    @Length(max=36, message = "人才Id不能大于36")
    private String talentId;

    /** 备注 */
    @ApiModelProperty(value = "备注", position = 3)
    @Length(max=500, message = "备注不能大于500")
    private String remark;

    /** 申报人Id */
    @ApiModelProperty(value = "申报人Id", position = 5)
    private String appPersonId;

    /** 人才类别Id */
    @ApiModelProperty(value = "人才类别Id", position = 5)
    private String talentCategory;

    /** 人才类别名称 */
    @ApiModelProperty(value = "人才类别名称", position = 5)
    private String talentCategoryName;

    /** 姓名 */
    @ApiModelProperty(value = "姓名", position = 4)
    private String personName;

    /** 证件号 */
    @ApiModelProperty(value = "证件号", position = 2)
    private String certId;

    /** 出生日期 */
    @ApiModelProperty(value = "出生日期", position = 2)
    private Date birthday;

    /** 性别 */
    @ApiModelProperty(value = "性别", position = 2)
    private String sex;

    /** 申报单位Id */
    @ApiModelProperty(value = "申报单位Id", position = 6)
    private String appUnitId;

    /** 申报单位名称 */
    @ApiModelProperty(value = "申报单位名称", position = 7)
    private String appUnitName;

    /** 手机号 */
    @ApiModelProperty(value = "手机号", position = 13)
    private String mobile;

    /** 专业Id */
    @ApiModelProperty(value = "专业Id", position = 5)
    private String spec;

    /** 专业名称 */
    @ApiModelProperty(value = "专业名称", position = 5)
    private String specName;

    private String key;
    private String title;
    private String description;

    private String pkey;
    private String ppkey;
}
