package com.yiboshi.science.param.dto;

import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "人才分组表DTO")
public class ComTalentGroupDTO extends BaseDTO {

    @ApiModelProperty(value = "人才分组名称", position = 1)
    @Length(max=60, message = "人才分组名称不能大于60")
    private String groupName;

    @ApiModelProperty(value = "人才分组年度", position = 2)
    private Integer groupYear;

    @ApiModelProperty(value = "人才分组排序", position = 2)
    private Integer displayOrder;

    @ApiModelProperty(value = "人才分组中的项目数", position = 4)
    private Integer talentCount;

    @ApiModelProperty(value = "人才分组中的专家数", position = 5)
    private Integer expertCount;

    /** 分配状态 0未分配 1已分配 */
    @ApiModelProperty(value = "分配状态", position = 6)
    private Integer assignState;

    /** 备注 */
    @ApiModelProperty(value = "备注", position = 7)
    @Length(max=200, message = "备注不能大于200")
    private String remark;

    @ApiModelProperty(value = "学科名称", position = 8)
    @Length(max=100, message = "学科名称不能大于100")
    private String knowledgeName;

    /** 专家Id */
    @ApiModelProperty(value = "专家Id", position = 9)
    @Length(max=36, message = "专家Id不能大于36")
    private String expertId;

    /** 人才Id */
    @ApiModelProperty(value = "人才Id", position = 10)
    @Length(max=36, message = "人才Id不能大于36")
    private String talentId;

    /** 项目分配Id */
    @ApiModelProperty(value = "项目分配Id", position = 11)
    @Length(max=36, message = "项目分配Id不能大于36")
    private String assignId;

    /** 人才分组分配专家列表 */
    List<ComTalentGroupAssignDTO> expertList;

    /** 人才分组人才明细 */
    List<ComTalentGroupDetailDTO> talentList;
}
