package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 项目组成员表DTO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "项目组成员表DTO")
public class ComProjectMembersDTO extends BaseDTO {
    /** 对象Id(项目Id/任务书Id) */
    @ApiModelProperty(value = "对象Id(项目Id/任务书Id)", position = 1 )
    @Length(max=36, message = "对象Id(项目Id/任务书Id)不能大于36")
    private String objectId;
    /** 姓名 */
    @ApiModelProperty(value = "姓名", position = 2 )
    @Length(max=60, message = "姓名不能大于60")
    private String name;
    /** 性别 */
    @ApiModelProperty(value = "性别", position = 4 )
    @Length(max=2, message = "性别不能大于2")
    private String sex;
    /** 出生年月 */
    @ApiModelProperty(value = "出生年月", position = 3 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date birthday;
    /** 证书类型 */
    @ApiModelProperty(value = "证书类型", position = 1)
    @Length(max=36, message = "证书类型不能大于36")
    private String certificateType;
    /** 证件号 */
    @ApiModelProperty(value = "证件号", position = 1)
    @Length(max=100, message = "证件号不能大于100")
    private String certId;

    /** 民族 */
    @ApiModelProperty(value = "民族", position = 9 )
    @Length(max=36, message = "民族不能大于36")
    private String nation;
    /** 国别或地区 */
    @ApiModelProperty(value = "国别或地区", position = 9 )
    @Length(max=50, message = "国别或地区不能大于50")
    private String country;
    /** 工作单位 */
    @ApiModelProperty(value = "工作单位", position = 7 )
    @Length(max=100, message = "工作单位不能大于100")
    private String workUnit;
    /** 职称 */
    @ApiModelProperty(value = "职称", position = 5 )
    @Length(max=36, message = "职称不能大于36")
    private String title;
    /** 最高学位 */
    @ApiModelProperty(value = "最高学位", position = 5 )
    @Length(max=36, message = "最高学位不能大于36")
    private String degree;
    /** 电子邮箱 */
    @ApiModelProperty(value = "电子邮箱", position = 8)
    @Length(max=100, message = "学历不能大于100")
    private String email;
    /** 手机 */
    @ApiModelProperty(value = "职务", position = 9 )
    @Length(max=36, message = "职务不能大于36")
    private String mobile;
    /** 电话 */
    @ApiModelProperty(value = "职务", position = 9 )
    @Length(max=36, message = "职务不能大于36")
    private String telephone;
    /** 传真 */
    @ApiModelProperty(value = "职务", position = 9 )
    @Length(max=36, message = "职务不能大于36")
    private String fax;
    /** 项目分工 */
    @ApiModelProperty(value = "项目分工", position = 8 )
    @Length(max=300, message = "项目分工不能大于300")
    private String projWork;
    /** 每年工作（月）*/
    @ApiModelProperty(value = "每年工作（月）", position = 9 )
    private BigDecimal forMonths;
    /** 从事专业 */
    @ApiModelProperty(value = "专业", position = 11)
    @Length(max=36, message = "专业不能大于36")
    private String spec;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 10 )
    private Integer showIndex;
    /** 角色 1项目负责人 2一般成员 */
    @ApiModelProperty(value = "角色 1项目负责人 2一般成员", position = 11 )
    private Integer role;
    /** 附件Id */
    @ApiModelProperty(value = "附件Id", position = 4 )
    private String fileId;
    /** 附件Id */
    @ApiModelProperty(value = "附件Id", position = 1 )
    @Length(max=36, message = "附件Id不能大于36")
    private String downloadId;
    /** 附件名 */
    @ApiModelProperty(value = "附件名", position = 6)
    private String fileName;
    /** URL */
    @ApiModelProperty(value = "URL", position = 7)
    private String downloadUrl;
    /** 转换文件URL */
    @ApiModelProperty(value = "转换文件URL", position = 7)
    private String convertUrl;

    /** 证件类型 */
    @ApiModelProperty(value = "证件类型", position = 9)
    private String certificateTypeName;
    /** 民族 */
    @ApiModelProperty(value = "民族", position = 9)
    private String nationName;
    /** 职称名称 */
    @ApiModelProperty(value = "职称名称", position = 9)
    private String titleName;
    /** 学位 */
    @ApiModelProperty(value = "学位", position = 8)
    private String degreeName;
    /** 专业 */
    @ApiModelProperty(value = "专业", position = 9)
    private String specName;
    /** 证件类型 */

    /** 学历 */
    @ApiModelProperty(value = "学历", position = 8)
    private String educationName;

    /** 项目组成员_总人数 */
    @ApiModelProperty(value = "项目组成员_总人数", position = 17 )
    private Integer memCount;
    /** 项目组成员_高职 */
    @ApiModelProperty(value = "项目组成员_高职", position = 18 )
    private Integer memHighCount;
    /** 项目组成员_中职 */
    @ApiModelProperty(value = "项目组成员_中职", position = 19 )
    private Integer memMiddleCount;
    /** 项目组成员_初职 */
    @ApiModelProperty(value = "项目组成员_初职", position = 20 )
    private Integer memLowCount;
    /** 项目组成员_其他 */
    @ApiModelProperty(value = "项目组成员_其他", position = 21 )
    private Integer memOtherCount;
    /** 项目组成员_博士后 */
    @ApiModelProperty(value = "项目组成员_博士研究生", position = 22 )
    private Integer memBshCount;
    /** 项目组成员_博士生 */
    @ApiModelProperty(value = "项目组成员_博士研究生", position = 22 )
    private Integer memBsCount;
    /** 项目组成员_硕士生 */
    @ApiModelProperty(value = "项目组成员_硕士研究生", position = 23 )
    private Integer memSsCount;
    /** 项目组成员_硕士生 */
    @ApiModelProperty(value = "项目组成员_学士", position = 24)
    private Integer memXsCount;
    /** 项目组成员_参加单位数 */
    @ApiModelProperty(value = "项目组成员_参加单位数", position = 25)
    private Integer workCount;
}