package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 申报人员简历表DTO
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "申报人员简历表DTO")
public class ComPersonResumeDTO extends BaseDTO {
    
    @ApiModelProperty(value = "主键")
    private String id;

    /** 人才申请Id */
    @ApiModelProperty(value = "人才申请Id")
    private String talentId;
    
    @ApiModelProperty(value = "简历类型")
    private String resumeType;

    @ApiModelProperty(value = "简历类型名称")
    private String resumeTypeName;
    
    @ApiModelProperty(value = "起始日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date resumeStart;
    
    @ApiModelProperty(value = "截止日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date resumeEnd;
    
    @ApiModelProperty(value = "机构名称")
    private String orgName;
    
    @ApiModelProperty(value = "职务")
    private String positionName;
    
    @ApiModelProperty(value = "简历备注")
    private String resumeRemark;

    @ApiModelProperty(value = "序号")
    private Integer showIndex;
} 