package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "专家项目分配表DTO")
public class ComExpertGroupMembersDTO extends BaseDTO {
    /** 专家组Id */
    @ApiModelProperty(value = "专家组Id", position = 2)
    @Length(max=36, message = "专家组Id不能大于36")
    private String groupId;
    /** 专家Id */
    @ApiModelProperty(value = "专家Id", position = 3)
    @Length(max=36, message = "专家Id不能大于36")
    private String expertId;
    /** 是否组长 1是 0否 */
    @ApiModelProperty(value = "是否组长 1是 0否", position = 4)
    private Integer leader;
}
