package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "评审分值表DTO")
public class ComEvaluationValueDTO extends BaseDTO {
    /** 专家分配表Id */
    @ApiModelProperty(value = "专家分配表Id", position = 1)
    @Length(max=36, message = "专家分配表Id不能大于36")
    private String assignId;
    /** 值对象Id */
    @ApiModelProperty(value = "值对象Id", position = 1)
    @Length(max=36, message = "值对象Id不能大于36")
    private String itemId;
    /** 明细 */
    @ApiModelProperty(value = "明细", position = 2)
    @Length(max=200, message = "明细不能大于200")
    private String detail;
    /** 数量 */
    @ApiModelProperty(value = "数量", position = 2)
    private BigDecimal count;
    /** 总分 */
    @ApiModelProperty(value = "总分", position = 3)
    private BigDecimal score;

    /** 内容 */
    @ApiModelProperty(value = "内容", position = 2)
    @Length(max=200, message = "内容不能大于200")
    private String description;
    /** 内容 */
    @ApiModelProperty(value = "内容", position = 2)
    @Length(max=200, message = "内容不能大于200")
    private String content;
    /** 单项得分 */
    @ApiModelProperty(value = "单项得分", position = 2)
    @Length(max=200, message = "单项得分不能大于200")
    private String scoreDetail;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 4)
    private Integer showIndex;
    /** 值类型：1单选、2多选、3打分 */
    @ApiModelProperty(value = "值类型：1单选、2多选、3打分", position = 5)
    private Integer valueType;
    /** 最大分值 */
    private Integer maxScore;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 6)
    @Length(max=200, message = "备注不能大于200")
    private String remark;

    /** 父Id */
    @ApiModelProperty(value = "父Id", position = 2)
    private String parentId1;
    /** 内容 */
    @ApiModelProperty(value = "内容", position = 2)
    @Length(max=200, message = "内容不能大于200")
    private String content1;

    /** 父Id */
    @ApiModelProperty(value = "父Id", position = 2)
    private String parentId2;
    /** 内容 */
    @ApiModelProperty(value = "内容", position = 2)
    @Length(max=200, message = "内容不能大于200")
    private String content2;

    /** 父Id */
    @ApiModelProperty(value = "父Id", position = 2)
    private String parentId3;
    /** 内容 */
    @ApiModelProperty(value = "内容", position = 2)
    @Length(max=200, message = "内容不能大于200")
    private String content3;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 2)
    @Length(max=200, message = "备注")
    private String remark3;

    /** 组名 */
    @ApiModelProperty(value = "组名", position = 2)
    @Length(max=200, message = "组名")
    private String groupName;

    /** 组序号 */
    @ApiModelProperty(value = "组序号", position = 2)
    @Length(max=200, message = "组序号")
    private List<Integer> groupItem;

    /** 合并单元格字段 */
    private Integer row1;

    /** 合并单元格字段 */
    private Integer row2;

    /** 合并单元格字段 */
    private Integer row3;
}
