package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.poi.hpsf.Decimal;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "评审项目表DTO")
public class ComEvaluationItemDTO extends BaseDTO {
    /** 评审表Id */
    @ApiModelProperty(value = "评审表Id", position = 1)
    @Length(max=36, message = "评审表Id")
    private String evaluationId;
    /** 父Id */
    @ApiModelProperty(value = "父Id", position = 2)
    private String parentId;
    /** 内容 */
    @ApiModelProperty(value = "内容", position = 2)
    @Length(max=200, message = "内容不能大于200")
    private String description;
    /** 内容 */
    @ApiModelProperty(value = "内容", position = 2)
    @Length(max=200, message = "内容不能大于200")
    private String content;
    /** 单项得分 */
    @ApiModelProperty(value = "单项得分", position = 2)
    @Length(max=200, message = "单项得分不能大于200")
    private String scoreDetail;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 4)
    private Integer showIndex;
    /** 值类型：1单选、2多选、3打分 */
    @ApiModelProperty(value = "值类型：1单选、2多选、3打分", position = 5)
    private Integer valueType;
    /** 最大分值 */
    private Decimal maxScore;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 6)
    @Length(max=200, message = "备注不能大于200")
    private String remark;
    /** 状态 1 正常 0 注销 */
    private Integer state;

    /** 父Id */
    @ApiModelProperty(value = "父Id", position = 2)
    private String parentId1;
    /** 内容 */
    @ApiModelProperty(value = "内容", position = 2)
    @Length(max=200, message = "内容不能大于200")
    private String content1;

    /** 父Id */
    @ApiModelProperty(value = "父Id", position = 2)
    private String parentId2;
    /** 内容 */
    @ApiModelProperty(value = "内容", position = 2)
    @Length(max=200, message = "内容不能大于200")
    private String content2;

    /** 父Id */
    @ApiModelProperty(value = "父Id", position = 2)
    private String parentId3;
    /** 内容 */
    @ApiModelProperty(value = "内容", position = 2)
    @Length(max=200, message = "内容不能大于200")
    private String content3;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 2)
    @Length(max=200, message = "备注")
    private String remark3;
}
