package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

/**
 * 配置表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "配置表VO")
public class SystemSet extends BaseEntity {

    /** 名称 */
    @ApiModelProperty(value = "名称", position = 1 )
    @Length(max=200, message = "名称不能大于200")
    private String name;
    /** 值 */
    @ApiModelProperty(value = "值", position = 2 )
    @Length(max=200, message = "值不能大于200")
    private String value;
    /** 注释 */
    @ApiModelProperty(value = "注释", position = 3 )
    @Length(max=200, message = "注释不能大于200")
    private String description;
}