package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

/**
 * 任务书预期成果表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "任务书预期成果表VO")
public class ComTaskTarget extends BaseEntity {
    /** 任务书Id */
    @ApiModelProperty(value = "任务书Id" )
    @Length(max=36, message = "任务书Id不能大于36")
    private String testId;
    /** 预期成果Id (参数表获取) */
    @ApiModelProperty(value = "预期成果Id (参数表获取)", position = 1 )
    @Length(max=36, message = "预期成果Id (参数表获取)不能大于36")
    private String targetId;
    /** 预期成果 */
    @ApiModelProperty(value = "预期成果", position = 2 )
    @Length(max=36, message = "预期成果不能大于36")
    private String result;
    /** 数量 */
    @ApiModelProperty(value = "数量", position = 3 )
    private Integer resultCount;
}