package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "评审表")
public class ComEvaluation extends BaseEntity {
    /** 评审表名称 */
    @ApiModelProperty(value = "评审表名称", position = 1)
    @Length(max=200, message = "评审表名称不能大于200")
    private String name;
    /** 总分 */
    @ApiModelProperty(value = "总分", position = 4)
    private BigDecimal score;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 1)
    @Length(max=200, message = "备注不能大于200")
    private String remark;
}
