package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.hibernate.validator.constraints.Length;

/**
 * 附件表
 *
 * @author lkl
 * @version 2021-08-25
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class ComDownload extends BaseEntity {

    @ApiModelProperty(value = "URL", position = 1)
    @Length(max=300, message = "URL不能大于300")
    private String downloadUrl;
    @ApiModelProperty(value = "转换文件URL", position = 2)
    @Length(max=300, message = "转换文件URL不能大于300")
    private String convertUrl;
    /** 附件名 */
    @ApiModelProperty(value = "附件名", position = 3)
    @Length(max=300, message = "附件名不能大于300")
    private String fileName;
    /** 后缀 */
    @ApiModelProperty(value = "后缀", position = 4)
    @Length(max=20, message = "后缀不能大于20")
    private String extension;
}