package com.yiboshi.science.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;

/**
 *  结题论文记录表
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Getter
@Setter
public class ComConclusionThesis extends BaseEntity {
    /** 结题信息表id */
    @ApiModelProperty(value = "结题信息表id", position = 1)
    @Length(max=36, message = "结题信息表id不能大于36")
    private String conclusionId;
    /** 论文名称 */
    @ApiModelProperty(value = "论文名称", position = 2)
    @Length(max=36, message = "论文名称不能大于100")
    private String name;
    /** 作者姓名 */
    @ApiModelProperty(value = "作者姓名", position = 3)
    @Length(max=36, message = "作者姓名不能大于50")
    private String author;
    /** 发表年月 */
    @ApiModelProperty(value = "发表年月", position = 4 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date publishDate;
    /** 发表在何种刊物 */
    @ApiModelProperty(value = "发表在何种刊物", position = 5)
    @Length(max=36, message = "发表在何种刊物不能大于200")
    private String publication;
    /** 国内外反映应用情况 */
    @ApiModelProperty(value = "国内外反映应用情况", position = 6)
    @Length(max=36, message = "国内外反映应用情况不能大于200")
    private String application;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 10 )
    private Integer showIndex;
    /** 附件Id */
    @ApiModelProperty(value = "附件Id", position = 1 )
    @Length(max=36, message = "附件Id不能大于36")
    private String downloadId;
}