package com.yiboshi.science.dao;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yiboshi.science.base.BaseDAO;
import com.yiboshi.science.entity.ComProjectConclusion;
import com.yiboshi.science.param.dto.ComProjectConclusionDTO;
import com.yiboshi.science.param.dto.DataStatisticsDTO;
import com.yiboshi.science.param.query.ComProjectConclusionQueryVO;
import org.apache.ibatis.annotations.Param;

/**
 * 结题信息表 DAO
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectConclusionDAO extends BaseMapper<ComProjectConclusion>, BaseDAO<ComProjectConclusionQueryVO, ComProjectConclusionDTO, ComProjectConclusion> {
    ComProjectConclusionDTO getConclusionByProjId(String projId);
    DataStatisticsDTO getCount(@Param("ew") Wrapper<ComProjectConclusion> queryWrapper);
}
