package com.yiboshi.science.config.web;

import java.io.File;
import org.apache.commons.io.FileUtils;

import cn.hutool.log.Log;
import com.yiboshi.science.service.SystemSetService;
import com.yiboshi.science.utils.SystemSetKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
class WebConfigurer implements WebMvcConfigurer {

    private static final boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");

    @Autowired
    private SystemSetService systemSetService;

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String property = System.getProperty("user.dir").replace("\\", "/");
        String basePath = systemSetService.getByKey(SystemSetKey.SysUploadFilePath);
//        if (!isWindows)
//            basePath = basePath.substring(0, basePath.length() - 1);
//        else
//            basePath = basePath;
        registry.addResourceHandler(basePath + "**").addResourceLocations("file:///" + property + basePath);
    }
}

