package com.yiboshi.science.api;

import com.alibaba.fastjson.JSON;
import com.yiboshi.arch.exception.BusinessException;
import com.yiboshi.science.param.dto.SMSParameterDTO;
import com.yiboshi.science.param.dto.SMSResponseDTO;
import com.yiboshi.science.param.dto.UserMenuDTO;
import com.yiboshi.science.service.LogsExceptionService;
import com.yiboshi.science.service.SystemSetService;
import com.yiboshi.science.utils.SystemSetKey;
import com.yiboshi.yac.model.OrgInfo;
import com.yiboshi.yac.model.dto.RoleDTO;
import com.yiboshi.yac.model.dto.UserDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;

@Component
@Slf4j
public class ApiHttpRequest {

    @Autowired
    private RestTemplateService restTemplateService;

    @Autowired
    private SystemSetService systemSetService;

    @Autowired
    private LogsExceptionService logsExceptionService;

    public ApiHttpRequest(RestTemplateService restTemplateService) {
        this.restTemplateService = restTemplateService;
    }

    public UserDTO remoteUserInfo() {
        String url = systemSetService.getByKey(SystemSetKey.AuthorityUrl) + "/v1/user/getUser";
        UserDTO dto = JSON.parseObject(JSON.toJSONString(restTemplateService.exchange(url, HttpMethod.GET, null, null)), UserDTO.class);
        return dto;
    }

    public List<UserMenuDTO> remoteMenuList() {
        String url = systemSetService.getByKey(SystemSetKey.AuthorityUrl) + "/v1/function/queryByCurrentUserId/23";
        List<UserMenuDTO> list = JSON.parseArray(JSON.toJSONString(restTemplateService.exchange(url, HttpMethod.GET, null, null)), UserMenuDTO.class);
        return list;
    }

    public OrgInfo remoteUnitInfo() {
        String url = systemSetService.getByKey(SystemSetKey.AuthorityUrl) + "/v1/user/queryLoginInfo";
        OrgInfo dto = JSON.parseObject(JSON.toJSONString(restTemplateService.exchange(url, HttpMethod.GET, null, null)), OrgInfo.class);
        return dto;
    }

    public OrgInfo remoteParentUnit(String id) {
        String url = systemSetService.getByKey(SystemSetKey.AuthorityUrl) + "/v1/orgInfo/queryById?id=" + id;
        OrgInfo dto = JSON.parseObject(JSON.toJSONString(restTemplateService.exchange(url, HttpMethod.GET, null, null)), OrgInfo.class);
        return dto;
    }

    public RoleDTO remoteRoleInfo() {
        String url = systemSetService.getByKey(SystemSetKey.AuthorityUrl) + "/resource/userRole/queryCurrentUser";
        List<RoleDTO> list = JSON.parseArray(JSON.toJSONString(restTemplateService.exchange(url, HttpMethod.GET, null, null)), RoleDTO.class);
        return list.stream().findFirst().get();
    }

    public boolean SMSSending(SMSParameterDTO sms) {
        try {
            String url = systemSetService.getByKey(SystemSetKey.SMSApiUrl) + "/api-public/v2/sms/send";
            String smsSrg = JSON.toJSONString(sms);
            // result = "{\"code\":0,\"success\":true,\"mobile\":\"151****5936\",\"key\":\"mobileCode:151****5936_42_4\"}";
            SMSResponseDTO obj = JSON.parseObject(restTemplateService.exchange(url, HttpMethod.POST, smsSrg, null), SMSResponseDTO.class);
            if (null != obj) {
                if (Objects.nonNull(obj.getCode()) && obj.getCode().equals(0))
                    return true;
                else
                    return false;
            }
            return false;
        } catch (Exception e) {
            String smsSrg = JSON.toJSONString(sms);
            logsExceptionService.logs(null, new RuntimeException("短信发送接口调用接口失败,参数:" + smsSrg), "短信发送失败！");
            return false;
        }
    }

    public boolean SMSCheck(String mobile, String code) {
        try {
            SMSResponseDTO smsDto;
            String para = "key=mobileCode:" + mobile + "_42_4&code=" + code;
            String url = systemSetService.getByKey(SystemSetKey.SMSApiUrl) + "/api-public/v2/sms/code/check?" + para;
            smsDto = JSON.parseObject(restTemplateService.exchange(url, HttpMethod.GET, null, null), SMSResponseDTO.class);
            if (null != smsDto) {
                if (Objects.nonNull(smsDto.getSuccess()) && smsDto.getSuccess())
                    return true;
            }
            return false;
        } catch (Exception e) {
            String para = "key=mobileCode:" + mobile + "_42_4&code=" + code;
            logsExceptionService.logs(null, new RuntimeException("短信验证码查询接口调用接口失败,参数:" + para), "短信验证码查询失败！");
            return false;
        }
    }
}
